 ; Ŀ
 ;   Deep - ddedit for individual attributes etc.                          
 ;   Copyright 1998, 2002, 2005, 2006 by Rocket Software Ltd.              
 ;   Software that works, for people who'd rather not...                   
 ; 

 ; Ŀ
 ;   Subroutine Edydat - see if the edit box gave a callback because it    
 ;   was <Entered>, if so return the current string it contained and       
 ;   terminate the dialog box, else return nil and do nothing.             
 ; 
 (DEFUN EDYDAT (reason / aa)
  (if (= reason 1)
      (progn
           (setq aa (get_tile "edit_dat"))
           (done_dialog)))
 aa)
 ; Ŀ
 ;   Edydat end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Editox - if OK was pressed, see if a valid string was      
 ;   present in the edit box, if so exit the dialog box and return it.     
 ;   Otherwise show an error.                                              
 ; 
 (DEFUN EDITOX (/ aa)
  (setq aa (get_tile "edit_dat"))
;  (cond ((or (= aa "") (= aa " "))
;         (set_tile "babtext" "Empty string bad")
;         (setq aa ()))
;        ((= (substr aa 1 1) " ")
;         (set_tile "babtext" "Leading space bad")
;         (setq aa ()))
;        (T (done_dialog)))
  (done_dialog)
 aa)
 ; Ŀ
 ;   Editox end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Bdab - call a dialog box to deal with a text string.       
 ; 
 (DEFUN BDAB (str typ depth attnam / str2 ret nest)
  (cond ((= typ "ATTRIB") (setq typ "Attribute"))
        ((= typ "TEXT") (setq typ "Text"))
        ((= typ "MTEXT") (setq typ "Mtext"))
        ((= typ "ATTDEF") (setq typ "Attdef")))
  (setq nest (if (> depth 0)
                 (strcat "Nesting: " (itoa depth))
                 ""))
  (setq ret 6)
  (setq dcl_id (load_dialog "deep.dcl"))
  (while (= ret 6)
         (new_dialog "deep" dcl_id)            ; must come before data for box
         (action_tile "edit_ok" "(setq str2 (editox))")
         (action_tile "edit_dat" "(setq str2 (edydat $reason))")
         (action_tile "example" "(done_dialog 6)")
         (set_tile "edit_dat" str)
         (if (= typ "Attdef")
             (set_tile "babtext" "** Caution: Attdef **")
             (set_tile "babtext" nest))
         (if attnam (setq typ (strcat typ ": " attnam))) ; put tag in header
         (set_tile "bab" (strcat "Deep Edit: " typ))
         (setq ret (start_dialog))
         (if (= ret 6)
             (progn
                  (setq nn (nentsel "\nSelect source text:\n"))
                  (if nn (setq cc (assoc 1 (entget (car nn)))))
                  (if cc (setq str (cdr cc))))))
  (unload_dialog dcl_id)
 str2)
 ; Ŀ
 ;   Bdab end.                                                             
 ; 

 ; Ŀ
 ;   Isxref: see if a given block is an xref.                              
 ;   Arguments: Blnam, either an entity name or a block name string.       
 ;   Returns T if the block was an xref, else nil.                         
 ; 
 (DEFUN ISXREF (blnam / dat xp isxrf)
  (if (= (type blnam) 'ename)
      (setq blnam (cdr (assoc 2 (entget blnam)))))
  (setq dat (tblsearch "block" blnam))
  (setq xp (cdr (assoc 70 dat)))
  (setq isxrf (logand xp 4))
 (if (= isxrf 4) T ()))
 ; Ŀ
 ;   Isxref end.                                                           
 ; 

 ; Ŀ
 ;   Deep.                                                                 
 ; 
 (DEFUN C:DEEP (/ *error* snapp enam typ str outer xrefp cc nn atnam depth)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a strictly local error handler.                                  
 ; 
 (defun *error* (shk)
  (setvar "snapmode" snapp)
  (command "undo" "end")
  (if (/= shk "") (write-line shk))
 (princ))
 ; Ŀ
 ;   Ask for an entity.                                                    
 ; 
  (if (setq enam (car (setq nent (nentsel "Select something textlike: "))))
      (setq typ (cdr (assoc 0 (setq entt (entget enam))))))
  (if (and typ (or (= "TEXT" typ) (= "MTEXT" typ) (= "ATTDEF" typ)
                                                  (= "ATTRIB" typ)))
      (progn
           (setq str (cdr (assoc 1 entt)))
           (setq outer (car (reverse (setq depth (car (reverse nent))))))
           (if (= (type outer) 'ENAME)
               (progn
                    (setq xrefp (isxref outer))
                    (setq depth (length depth)))
               (setq depth 0))
           (cond (xrefp
                  (prompt "\nCan't change text in an Xref."))
                 ((and (= typ "MTEXT") (assoc 3 entt))
                  (prompt "\nComplex Mtext - use the mtext editor."))
                 (t
                  (if (= typ "ATTRIB")
                      (setq atnam (cdr (assoc 2 entt))))
                  (setq cc (bdab str typ depth atnam))))
           (if cc
               (progn
                    (entmod (subst (cons 1 cc) (assoc 1 entt) entt))
                    (entupd enam)
                    (if (= (type outer) 'ENAME) (entupd outer))))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* "")
 (princ))